package com.agilex.healthcare.veteranappointment.datalayer.patient;

import com.agilex.healthcare.veteranappointment.domain.VARPatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;
import com.agilex.healthcare.veteranappointment.datalayer.AbstractMapper;

public class PatientMetadataMapper extends AbstractMapper<PatientMetadata, VARPatientDataCollection<PatientMetadata>, PatientMetadataPo> {
	
	@Override
	public PatientMetadata toDto(PatientMetadataPo po) {
		if (po != null) {
			PatientMetadata dto = new PatientMetadata();
			dto.setPatientId(po.getUserId());
			dto.setLastAppointmentRequestAccessDate(po.getLastAppointmentRequestAccessDate());
			
			return dto;
		}
		return null;
	}

	@Override
	public PatientMetadataPo toPo(PatientMetadata dto) {
		if (dto != null) {
			PatientMetadataPo po = new PatientMetadataPo();
			po.setUserId(dto.getPatientId());
			po.setLastAppointmentRequestAccessDate(dto.getLastAppointmentRequestAccessDate());
			
			return po;
		}
		return null;
	}

}
